<?php
$username = 'dans@fcsus.com';
$password = '#PdC#M!9sP5T';
$order_id = 5006553;
$new_status_code = 3; // Completed
$note_message = "Order marked as completed via API automation.";

// === Step 1: Authenticate ===
$auth_url = 'https://guru.api.sellercloud.us/rest/api/token';

$auth_payload = json_encode([
    'Username' => $username,
    'Password' => $password
]);

$auth_headers = [
    'Content-Type: application/json'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $auth_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $auth_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $auth_headers);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code !== 200) {
    die("❌ Auth failed. HTTP Code: $http_code\n$response\n");
}

$token_data = json_decode($response, true);
$access_token = $token_data['access_token'];
echo "✅ Authenticated.\n";

// === Step 2: Update Order Status ===
$status_url = 'https://guru.api.sellercloud.us/rest/api/Orders/StatusCode';
$status_payload = json_encode([
    "Orders" => [$order_id],
    "Status" => $new_status_code
]);

$status_headers = [
    "Content-Type: application/json",
    "Accept: application/json",
    "Authorization: Bearer $access_token"
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $status_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
curl_setopt($ch, CURLOPT_POSTFIELDS, $status_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $status_headers);
$response = curl_exec($ch);
$status_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($status_code === 200) {
    echo "✅ Order $order_id status updated to $new_status_code.\n";
} else {
    die("❌ Failed to update order status. HTTP Code: $status_code\n$response\n");
}

// === Step 3: Add Note ===
$note_url = "https://guru.api.sellercloud.us/rest/api/Orders/$order_id/Notes";
$note_payload = json_encode([
    "Message" => $note_message,
    "Category" => 0,
    "IsPinned" => false
]);

$note_headers = [
    "Content-Type: application/json",
    "Accept: application/json",
    "Authorization: Bearer $access_token"
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $note_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $note_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $note_headers);
$response = curl_exec($ch);
$note_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($note_code === 200 || $note_code === 201) {
    echo "✅ Note added to order $order_id.\n";
} else {
    echo "❌ Failed to add note. HTTP Code: $note_code\n$response\n";
}
?>
