<?php
class read_orders {
    public $order_db;
    public $test_order_db;
    public $reports;

    public function __construct() {
        $this->order_db = mysqli_connect(DATABASE_SERVER, DATABASE_USER_ONE, DATABASE_PASSWORD_ONE, DATABASE_FCSUSDBADMIN_ORDERS);
        $this->test_order_db = mysqli_connect(DATABASE_SERVER, DATABASE_USER_ONE, DATABASE_PASSWORD_ONE, DATABASE_FCSUSDBADMIN_ORDERS);
        $this->reports = mysqli_connect(DATABASE_SERVER, DATABASE_USER_ONE, DATABASE_PASSWORD_ONE, REPORTS);
    }

    public function get_amazon_order_sku($order_id) {
        $sql = "SELECT sku FROM amazon_all_store_order WHERE amazon_order_id = '$order_id'";
        $result = mysqli_query($this->reports, $sql) or die(mysqli_error($this->reports));

        while ($row = mysqli_fetch_assoc($result)) {
            $sku_serialized = $row['sku'];
            $sku = unserialize($sku_serialized);
        }

        return $sku ?? [];
    }

    public function get_ebay_sds_sku($ebay_orderid, $fpl) {
        $token = ebay_sds_token_for_orders;
        return $this->get_ebay_order_sku($ebay_orderid, $fpl, $token);
    }

    public function get_ebay_ec_sku($ebay_orderid, $fpl) {
        $token = ebay_ec_token_for_orders;
        return $this->get_ebay_order_sku($ebay_orderid, $fpl, $token);
    }

    private function get_ebay_order_sku($ebay_orderid, $fpl, $token) {
        $endpoint = "https://api.ebay.com/ws/api.dll";
        $headers = [
            'X-EBAY-API-COMPATIBILITY-LEVEL:967',
            'X-EBAY-API-CALL-NAME: GetOrders',
            'X-EBAY-API-SITEID:0',
            'Content-Type: text/xml;charset=utf-8'
        ];

        $xmlrequest = "<?xml version='1.0' encoding='utf-8'?>\n";
        $xmlrequest .= "<GetOrdersRequest xmlns=\"urn:ebay:apis:eBLBaseComponents\">\n";
        $xmlrequest .= "<RequesterCredentials><eBayAuthToken>$token</eBayAuthToken></RequesterCredentials>\n";
        $xmlrequest .= "<OrderIDArray><OrderID>$ebay_orderid</OrderID></OrderIDArray>\n";
        $xmlrequest .= "<OutputSelector>OrderID</OutputSelector>\n";
        $xmlrequest .= "<OutputSelector>Item</OutputSelector>\n";
        $xmlrequest .= "<OutputSelector>QuantityPurchased</OutputSelector>\n";
        $xmlrequest .= "<OutputSelector>SellingManagerSalesRecordNumber</OutputSelector>\n";
        $xmlrequest .= "</GetOrdersRequest>";

        $session = curl_init($endpoint);
        curl_setopt($session, CURLOPT_POST, true);
        curl_setopt($session, CURLOPT_HTTPHEADER, $headers);
        curl_setopt($session, CURLOPT_POSTFIELDS, $xmlrequest);
        curl_setopt($session, CURLOPT_RETURNTRANSFER, true);

        $responsexml = curl_exec($session);
        curl_close($session);

        $xml = simplexml_load_string($responsexml, 'SimpleXMLElement', LIBXML_NOCDATA);
        $_xml = json_encode($xml);
        $_xml = str_replace("'", "", $_xml);

        $insert = "INSERT INTO api_response(4pl_unique_id, response) VALUES ('$fpl', '$_xml')";
        mysqli_query($this->order_db, $insert);

        $orders = json_decode($_xml, true);
        $ack = $orders['Ack'] ?? '';
        $order_array = $orders['OrderArray']['Order'] ?? [];

        $transaction = $order_array['TransactionArray']['Transaction'] ?? [];
        $skuList = [];

        if (isset($transaction['Item'])) {
            // single-item order
            $skuList[] = [
                'sku' => $transaction['Item']['SKU'] ?? '',
                'qty' => $transaction['QuantityPurchased'] ?? '',
                'seller_record' => $transaction['ShippingDetails']['SellingManagerSalesRecordNumber'] ?? ''
            ];
        } elseif (is_array($transaction)) {
            // multi-item order
            foreach ($transaction as $item) {
                $skuList[] = [
                    'sku' => $item['Item']['SKU'] ?? '',
                    'qty' => $item['QuantityPurchased'] ?? '',
                    'seller_record' => $item['ShippingDetails']['SellingManagerSalesRecordNumber'] ?? ''
                ];
            }
        }

        return ($ack == 'Success') ? $skuList : [];
    }
}
