<?php
// === Step 1: Credentials and Variables ===
$username = 'sachink@fcsus.com'; // username
$password = 'je9d!c6NaqjC'; //password
$orderId = 5006545;

$noteData = [
    "Message"   => "Test API Notes inserted by Sachin Using Sub-User",
    "Category"  => 0,           // 0 = General, 1 = Customer Instructions, 2 = Customer Service Note
    "IsPinned"  => true         // Optional: pin note
];

// === Step 2: Authenticate ===
$auth_url = 'https://guru.api.sellercloud.us/rest/api/token';

$auth_payload = json_encode([
    'Username' => $username,
    'Password' => $password
]);

$auth_headers = [
    'Content-Type: application/json',
    'Content-Length: ' . strlen($auth_payload)
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $auth_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $auth_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $auth_headers);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code !== 200) {
    die("❌ Authentication failed. HTTP Code: $http_code\n$response\n");
}

$data = json_decode($response, true);
$access_token = $data['access_token'];
echo "✅ Authenticated.\n";

// === Step 3: Post Order Note ===
$note_url = "https://guru.api.sellercloud.us/rest/api/Orders/$orderId/Notes";

$note_payload = json_encode($noteData);

$note_headers = [
    "Content-Type: application/json",
    "Accept: application/json",
    "Authorization: Bearer $access_token"
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $note_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $note_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $note_headers);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// === Step 4: Output Result ===
if ($http_code == 200 || $http_code == 201) {
    echo "✅ Note added to order $orderId successfully.\n";
    echo "Response: $response\n";
} else {
    echo "❌ Failed to add note. HTTP Code: $http_code\n";
    echo "Response: $response\n";
}
?>
