<?php
// === Configuration ===
$username = 'dans@fcsus.com';
$password = '#PdC#M!9sP5T';
$productID = 'NM01096152_b2b'; // Replace with your actual product SKU

$base_url = 'https://guru.api.sellercloud.us/rest';

// === Step 1: Authenticate ===
$auth_url = $base_url . '/api/token';

$auth_payload = json_encode([
    'Username' => $username,
    'Password' => $password
]);

$auth_headers = [
    'Content-Type: application/json'
];

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $auth_url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_POSTFIELDS => $auth_payload,
    CURLOPT_HTTPHEADER => $auth_headers
]);

$auth_response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code !== 200) {
    die("❌ Authentication failed. HTTP $http_code\nResponse: $auth_response\n");
}

$token = json_decode($auth_response, true)['access_token'];
echo "✅ Authenticated. Token acquired.\n";

// === Step 2: Retrieve Inventory Metadata ===
$inventory_url = $base_url . '/api/Inventory/Details?productID=' . urlencode($productID);

$headers = [
    'Authorization: Bearer ' . $token,
    'Content-Type: application/json',
    'Accept: application/json'
];

$ch = curl_init();
curl_setopt_array($ch, [
    CURLOPT_URL => $inventory_url,
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_HTTPHEADER => $headers
]);

$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

$data = json_decode($response);
echo '<pre>';
print_r($data);
if (isset($data->Inventory->AggregateQty)) {
    $aggregateQty = $data->Inventory->AggregateQty;
    echo "✅ AggregateQty: $aggregateQty\n";
} else {
    echo "❌ AggregateQty not found in response.\n";
}