<?php
// === Credentials and Order Config ===
$username = 'dans@fcsus.com';
$password = '#PdC#M!9sP5T';
$orderId = 5006826;

$custom_columns = [
    [
        "ColumnName" => "CUSTOMEORDERSTATUS",
        "Value" => "ManagementReview"
    ],
    // Add more columns here if needed
];

// === Step 1: Authenticate ===
$auth_url = 'https://guru.api.sellercloud.us/rest/api/token';

$auth_payload = json_encode([
    'Username' => $username,
    'Password' => $password
]);

$auth_headers = [
    'Content-Type: application/json'
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $auth_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_POSTFIELDS, $auth_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $auth_headers);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http_code !== 200) {
    die("❌ Authentication failed. HTTP Code: $http_code\n$response\n");
}

$data = json_decode($response, true);
$access_token = $data['access_token'];
echo "✅ Authenticated successfully.\n";

// === Step 2: PUT Custom Columns ===
$custom_column_url = "https://guru.api.sellercloud.us/rest/api/Orders/$orderId/CustomColumns/Multiple";

$custom_column_payload = json_encode($custom_columns);

$headers = [
    "Content-Type: application/json",
    "Accept: application/json",
    "Authorization: Bearer $access_token"
];

$ch = curl_init();
curl_setopt($ch, CURLOPT_URL, $custom_column_url);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_CUSTOMREQUEST, "PUT");
curl_setopt($ch, CURLOPT_POSTFIELDS, $custom_column_payload);
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
$response = curl_exec($ch);
$http_code = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

// === Step 3: Output ===
if ($http_code == 200) {
    echo "✅ Successfully updated custom columns for order $orderId\n";
    echo "Response: $response\n";
} else {
    echo "❌ Failed to update columns. HTTP Code: $http_code\n$response\n";
}
?>
